/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.SimpleSourceViewerConfiguration;
import com.aptana.editor.common.contentassist.ContentAssistant;
import com.aptana.editor.ruby.RubyAutoIndentStrategy;
import com.aptana.editor.ruby.RubyEditorPlugin;
import com.aptana.editor.ruby.RubySourceConfiguration;
import com.aptana.editor.ruby.core.RubyDoubleClickStrategy;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class RubySourceViewerConfiguration
extends SimpleSourceViewerConfiguration {
    private RubyDoubleClickStrategy fDoubleClickStrategy;

    public RubySourceViewerConfiguration(IPreferenceStore preferences, AbstractThemeableEditor editor) {
        super(preferences, editor);
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        IContentAssistant assistant = super.getContentAssistant(sourceViewer);
        if (assistant instanceof ContentAssistant) {
            ((ContentAssistant)assistant).enablePrefixCompletion(true);
        }
        return assistant;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new RubyDoubleClickStrategy();
        }
        return this.fDoubleClickStrategy;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new RubyAutoIndentStrategy(contentType, (SourceViewerConfiguration)this, sourceViewer, RubyEditorPlugin.getDefault().getPreferenceStore())};
    }

    public ISourceViewerConfiguration getSourceViewerConfiguration() {
        return RubySourceConfiguration.getDefault();
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("com.aptana.ruby.ui.rubyCode", this.getEditor());
        return targets;
    }
}

